/**
 * Work in Miyagi 共通JavaScript
 * 企業向け(company.html)と求職者向け(foreigner.html)で使用
 */

document.addEventListener('DOMContentLoaded', () => {
    
    // --- 1. スムーススクロール機能 ---
    
    // アンカーリンクの処理 (href="#...")
    const smoothScrollLinks = document.querySelectorAll('a[href^="#"]:not([href="#"])');
    
    smoothScrollLinks.forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            // クラスに 'js-no-scroll' がある場合は無視する
            if (this.classList.contains('js-no-scroll')) return;

            e.preventDefault();
            const targetId = this.getAttribute('href');
            const target = document.querySelector(targetId);
            
            if (target) {
                // ヘッダーの高さ（スティッキーナビがあるため調整）
                // PC: 80px + サブナビ 50px = 130px 程度余裕を持たせる
                const headerOffset = 140; 
                const elementPosition = target.getBoundingClientRect().top;
                const offsetPosition = elementPosition + window.pageYOffset - headerOffset;

                window.scrollTo({
                    top: offsetPosition,
                    behavior: "smooth"
                });
            }
        });
    });

    // 「トップへ戻る」ボタン等の処理 (class="js-scroll-top")
    const scrollTopButtons = document.querySelectorAll('.js-scroll-top');
    scrollTopButtons.forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.preventDefault();
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    });


    // --- 2. 支援制度フィルタリング機能 (企業向けページ用) ---
    
    // フィルタリングボタンが存在する場合のみ実行
    const filterButtons = document.querySelectorAll('.support-tab');
    
    if (filterButtons.length > 0) {
        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                // ボタンIDからカテゴリを取得 (例: tab-sup-cost -> cost)
                const category = this.id.replace('tab-sup-', '');
                
                // 1. タブのスタイル更新
                filterButtons.forEach(btn => {
                    // アクティブクラスの削除（Tailwindクラスを直接操作）
                    btn.classList.remove('active', 'text-miyagi-base', 'border-b-4', 'border-miyagi-base');
                    btn.classList.add('text-gray-500');
                });

                // クリックされたボタンをアクティブにする
                this.classList.remove('text-gray-500');
                this.classList.add('active', 'text-miyagi-base', 'border-b-4', 'border-miyagi-base');

                // 2. カードの表示切り替え
                const cards = document.querySelectorAll('.support-card');
                cards.forEach(card => {
                    // アニメーション用クラスを一旦削除してリフローさせる
                    card.classList.remove('fade-in');
                    void card.offsetWidth; // リフロー発生

                    const cardCategory = card.getAttribute('data-category');
                    
                    if (category === 'all' || cardCategory === category) {
                        card.style.display = 'block';
                        card.classList.add('fade-in');
                    } else {
                        card.style.display = 'none';
                    }
                });
            });
        });
    }

    // --- 3. 画像読み込みエラーのハンドリング (県章GIFなど) ---
    const images = document.querySelectorAll('img');
    images.forEach(img => {
        img.addEventListener('error', function() {
            // 代替要素（直後の兄弟要素など）があれば表示する
            if (this.nextElementSibling && this.nextElementSibling.classList.contains('hidden')) {
                this.style.display = 'none';
                this.nextElementSibling.classList.remove('hidden');
            }
        });
    });

});